package complex_operations;

import db_context.DbContext;
import db_context.MyExceptions;
import row_data_gateway.*;
import row_data_gateway.Package;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;

public class Simulation {
    private static final Simulation INSTANCE = new Simulation();
    public static Simulation getInstance() {
        return INSTANCE;
    }
    private Simulation() {
    }

    public void SimulateTransport(int transport_id, boolean on_way_back) throws SQLException, MyExceptions.NotSuchIdException {
        Transport transport = TransportFinder.getInstance().findById(transport_id);
        Package p = PackageFinder.getInstance().findById(transport.getPackage_id());
        Driver driver = DriverFinder.getInstance().findByTransportId(transport_id);

        String[] path = transport.getRoute().substring(1, transport.getRoute().length()-1).split(",");
        if(!p.getStatus().equals("ready")) throw new SQLException("this package is either new or already delivered");
        //if(p.getDelivery_price())
        p.setStatus("on_way");
        p.update();

        for(int i = 1; i < path.length-1; i++){
            long diff = (transport.getArrival_time().getTime() - transport.getDeparture_time().getTime()) / (path.length - 1);
            Timestamp t = new Timestamp(transport.getDeparture_time().getTime() + i*diff);
            SimulateOneStep(driver, transport, p, Integer.parseInt(path[i]), t);

            if(p.getDamage() >= 100){
                System.out.println("Package is Totally damaged and thus cant be delivered, will be refunded soon");
                p.setDamage(100);
                p.setStatus("damaged");
                p.update();
                break;
            }
        }

        if(p.getDamage() < 100){
            TryToDeliver(p, on_way_back);
            if(p.getStatus().equals("ready")){
                System.out.println("Receiver was unreachable, package will be delivered back to sender");
                transport.setRoute(OtherOperations.getInstance().ReversePath(transport));
                transport.update();
                SimulateTransport(transport_id, true);
            }else if(p.getStatus().equals("delivered")){
                System.out.println("Package with id: " + p.getId() + " was successfully delivered");
            }else if(p.getStatus().equals("company_failed")){
                System.out.println("Sender of package was also unreachable");
            }

        }
        if(p.getStatus().equals("delivered")) driver.setDelivered_packages(driver.getDelivered_packages() + 1);
        if(!p.getStatus().equals("ready")) driver.setTransport_id(null);
        driver.update();
    }

    public void SimulateOneStep(Driver driver, Transport transport, Package p, int dest_id, Timestamp time) throws SQLException, MyExceptions.NotSuchIdException {
        DbContext.getConnection().setTransactionIsolation(Connection.TRANSACTION_REPEATABLE_READ);
        DbContext.getConnection().setAutoCommit(false);
        try{
            SQLLock("drivers");
            SQLLock("packages");
            int damage = 0; if(Math.random() > 0.98) damage = (int)Math.round(Math.random() * 100 + 1);
            System.out.println("Driver with id: " + driver.getId() + " Moved from location " + driver.getLocation_id() + " to location " + dest_id);
            if(damage > 0) System.out.println("Accident occurred, damage: " + damage + "%");
            else System.out.println("No accident");

            Segment segment = new Segment();
            segment.setTransport_id(transport.getId());
            segment.setConnection_id(OtherOperations.getInstance().findConnectionFromLocations(driver.getLocation_id(), dest_id));
            segment.setAccident(damage == 0);
            segment.setDamage(damage);
            segment.setTime(time);
            segment.insert();

            driver.setLocation_id(dest_id);
            driver.update();

            p.setDamage(p.getDamage() + damage);
            p.update();
            DbContext.getConnection().commit();
        }catch(Exception e){
            DbContext.getConnection().rollback();
            System.out.println(e.getMessage());
        }finally {
            DbContext.getConnection().setAutoCommit(true);
        }
    }


    public void TryToDeliver(Package p, boolean on_way_back) throws SQLException, MyExceptions.NotSuchIdException {
        DbContext.getConnection().setTransactionIsolation(Connection.TRANSACTION_REPEATABLE_READ);
        DbContext.getConnection().setAutoCommit(false);
        try{
            SQLLock("packages");
            boolean reachable = OtherOperations.getInstance().IsPersonReachable(p.getRecipient_id());
            p.setDelivery_attempts(p.getDelivery_attempts() + 1);

            int var = 0; if(on_way_back) var = 3;
            while(reachable == false && p.getDelivery_attempts() < 3 + var){
                p.setDelivery_attempts(p.getDelivery_attempts() + 1);
                //s najakou pravdepodobnostou zmeniť reachable
                //reachable = OtherOperations.getInstance().IsPersonReachable(p.getRecipient_id());
            }

            if(reachable == true) p.setStatus("delivered");
            else if (on_way_back) p.setStatus("company_failed");
            else p.setStatus("ready");
            p.update();

            DbContext.getConnection().commit();
        }catch(Exception e){
            DbContext.getConnection().rollback();
            System.out.println(e.getMessage());
        }finally {
            DbContext.getConnection().setAutoCommit(true);
        }
    }

    public void SQLLock(String table) throws SQLException {
        try(PreparedStatement s = DbContext.getConnection().prepareStatement("lock " + table + " in exclusive mode")){
            s.execute();
        }
    }
}
